package com.bcxin.risk.report.material.dto;

import lombok.Data;

import java.util.Map;

/**
 * 客户录入材料，供撰写用
 */
@Data
public class MaterialComposeValueDTO {

    private String classCode;

    private String className;

    private String menuName;

    private String attrName;

    private String attrCode;

    private String attrType;

    private String optionType;

    private String value;

    private String option;

    private String modify;

    public MaterialComposeValueDTO(){

    }

    public MaterialComposeValueDTO(Map<String,Object> map){
        this.classCode = safeTransfor(map.get("classCode"));
        this.className = safeTransfor(map.get("className"));
        this.menuName = safeTransfor(map.get("menuName"));
        this.attrName = safeTransfor(map.get("attrName"));
        this.attrCode = safeTransfor(map.get("attrCode"));
        this.attrType = safeTransfor(map.get("attrType"));
        this.optionType = safeTransfor(map.get("optionType"));
        this.value = safeTransfor(map.get("value"));
        this.option = safeTransfor(map.get("option"));
        this.modify = safeTransfor(map.get("modify"));
    }


    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}
