package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;


public enum SurveyTaskType {
	
	
	INQUIRY{public String getValue(){return "1";} public String getName(){return "询问";}}, 

	UPDATE {public String getValue(){return "2";} public String getName(){return "更新维护";}};

    public abstract String getValue();
    
    public abstract String getName();
    
    public static SurveyTaskType convert_value(String value){
    	if ( "1".equals(value) ) {
    		return SurveyTaskType.INQUIRY;
    	} else if ("2".equals(value)) {
    		return SurveyTaskType.UPDATE;
    	} 
    	return null;
    }
    
    public static SurveyTaskType convertName(String name){
    	if ( "询问".equals(name) ) {
    		return SurveyTaskType.INQUIRY;
    	} else if ("更新维护".equals(name)) {
    		return SurveyTaskType.UPDATE;
    	} 
    	return null;
    }
    
    public static List<SurveyTaskType> assginList(){
    	List<SurveyTaskType> list = new ArrayList<SurveyTaskType>();
    	list.add(SurveyTaskType.INQUIRY);
    	list.add(SurveyTaskType.UPDATE);
    	return list;
    }
}
