package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum ReportSchedule {
	
	/** 取消*/
	CANCEL {public String getValue(){return "88";} public String getCname(){return "已取消";}public String getEname(){return "CANCEL";}},
	
	NONE_SERVICE {public String getValue(){return "0";} public String getCname(){return "待选择服务机构";} public String getEname(){return "NONE_SERVICE";}},
	
	NONE {public String getValue(){return "99";} public String getCname(){return "未支付";} public String getEname(){return "NONE";}},
	
	/** 资料提交*/
	FILESUBMIT {public String getValue(){return "1";} public String getCname(){return "资料提交";} public String getEname(){return "FILESUBMIT";}}, 
	
	/** 报告撰写*/
	REPORTWRITING {public String getValue(){return "20";} public String getCname(){return "报告撰写";}public String getEname(){return "REPORTWRITING";}},
	
	/** 公安审批*/
	POLICEAPPROVAL{public String getValue(){return "30";} public String getCname(){return "公安审批";}public String getEname(){return "POLICEAPPROVAL";}},
	
	/** 审批不通过*/
	APPROVALREJECT{public String getValue(){return "35";} public String getCname(){return "审批不通过";}public String getEname(){return "APPROVALREJECT";}},
	
	/** 设施搭建*/
	CONSTRUCTION{public String getValue(){return "40";} public String getCname(){return "设施搭建";}public String getEname(){return "CONSTRUCTION";}},
	
	/** 活动进行*/
	DURING{public String getValue(){return "45";} public String getCname(){return "活动进行";}public String getEname(){return "DURING";}},
	
	/** 活动结束*/
	END{public String getValue(){return "50";} public String getCname(){return "活动结束";}public String getEname(){return "END";}};
	
	
	

    public abstract String getValue();
    
    public abstract String getCname();
    
    public abstract String getEname();

    public static ReportSchedule convertValue(String value){
    	if ( "0".equals(value) ) {
    		return ReportSchedule.NONE_SERVICE;
    	} else if ( "99".equals(value) ) {
    		return ReportSchedule.NONE;
    	} else if ( "1".equals(value) ) {
    		return ReportSchedule.FILESUBMIT;
    	} else if ("20".equals(value)) {
    		return ReportSchedule.REPORTWRITING;
    	} else if ("30".equals(value)) {
    		return ReportSchedule.POLICEAPPROVAL;
    	} else if ("35".equals(value)) {
    		return ReportSchedule.APPROVALREJECT;
    	} else if ("40".equals(value)) {
    		return ReportSchedule.CONSTRUCTION;
    	} else if ("45".equals(value)) {
    		return ReportSchedule.DURING;
    	} else if ("50".equals(value)) {
    		return ReportSchedule.END;
    	} else if ("88".equals(value)) {
    		return ReportSchedule.CANCEL;
    	} 
    	return null;
    }
    
    public static ReportSchedule convertEname(String ename){
    	if ( "NONE_SERVICE".equals(ename) ) {
    		return ReportSchedule.NONE_SERVICE;
    	} else if ( "NONE".equals(ename) ) {
    		return ReportSchedule.NONE;
    	} else if ( "FILESUBMIT".equals(ename) ) {
    		return ReportSchedule.FILESUBMIT;
    	} else if ("REPORTWRITING".equals(ename)) {
    		return ReportSchedule.REPORTWRITING;
    	} else if ("POLICEAPPROVAL".equals(ename)) {
    		return ReportSchedule.POLICEAPPROVAL;
    	} else if ("APPROVALREJECT".equals(ename)) {
    		return ReportSchedule.APPROVALREJECT;
    	} else if ("CONSTRUCTION".equals(ename)) {
    		return ReportSchedule.CONSTRUCTION;
    	} else if ("DURING".equals(ename)) {
    		return ReportSchedule.DURING;
    	} else if ("END".equals(ename)) {
    		return ReportSchedule.END;
    	} else if ("CANCEL".equals(ename)) {
    		return ReportSchedule.CANCEL;
    	} 
    	return null;
    }
    
    public static List<ReportSchedule> list(){
    	ArrayList<ReportSchedule> list = new ArrayList<ReportSchedule>();
    	list.add(ReportSchedule.NONE_SERVICE);
    	list.add(ReportSchedule.NONE);
    	list.add(ReportSchedule.FILESUBMIT);
    	list.add(ReportSchedule.REPORTWRITING);
    	list.add(ReportSchedule.POLICEAPPROVAL);
    	list.add(ReportSchedule.APPROVALREJECT);
    	list.add(ReportSchedule.CONSTRUCTION);
    	list.add(ReportSchedule.DURING);
    	list.add(ReportSchedule.END);
		return list;
    	
    }
    
    public static boolean crossApproval(ReportSchedule currentSchedule){
    	if ( currentSchedule.equals(CONSTRUCTION)
    			|| currentSchedule.equals(DURING)
    			|| currentSchedule.equals(END) ) {
    		return true;
    	}
    	return false;
    }
    
}
