package com.bcxin.risk.report.domain;

import com.bcxin.risk.activity.*;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * 报告
 */
@Entity
@Table(name = "RISK_Report")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
public class Report extends BaseBean {

	private static final long serialVersionUID = 1L;

	private String name;//报告名称
	
	private String reportStatus;//报告状态

	private String reportSubStatus;//报告小状态

	@ManyToOne(targetEntity = User.class, fetch = FetchType.EAGER, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "user_id")
	private User user;

	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "activity_id")
	private Activity activity;

	private String reportUrgent;// 加急服务 （字典）

	private String expressMode;// 发票+纸质报告是否需要类型 （字典）

	private String cancelReason;// 备注（打回原因）

	private String postCompose;//是否已经开始撰写，主要看是否选择报告框架（1代表已经开始，0为未开始）

	@Temporal(TemporalType.TIMESTAMP)
	private Date assignDate; //如果是自营机构的评估报告，需要分配任务，这是分配任务的时间

	/**
	 * 专家审核标志
	 */
	private String approvalFlag;//（1代表已经审核，0为未开始）

	/**
	 * 专家审核意见
	 */
	private String approvalComment;

	private String composeComplete;//所有目录是否已经全部录完，（1代表已经完成，0为未完成）

	private String fullEdit;//是否已经开始全文编辑，（1代表已经是，0为不是）

	private String signature;//是否已经签名，（1代表已经是，0为不是）

}
