package com.bcxin.risk.org.domain;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.user.domain.User;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 待审核的政府机构
 * @author llc
 *
 */
@Entity
@Table(name = "risk_govOrg")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class GovOrg extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 登陆用户名，与user对应
	 */
	private String userName;

	/**
	 * 单位名称
	 */
	private String name;

	/**
	 * 单位地址
	 */
	private String address;

	/**
	 * 政府单位标志
	 */
	private String govOrgFlag;

	/**
	 * 组织机构代码
	 */
	private String organizationCode;

	/**
	 * 组织机构代码扫描件
	 */
	private String organizationCode_license;

	/**
	 * 审核状态（字典）
	 */
	private String approvalStatus;

	/**
	 * 审核备注
	 */
	private String comment;

	/**
	 * 用户
	 */
	@OneToOne(targetEntity = User.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "user_id")
	private User user;

	/**
	 * 区域ID
	 */
	private Long area_id;

	/**
	 * 城市ID
	 */
	private Long city_id;

	/**
	 * 省份ID
	 */
	private Long province_id;

}
