package com.bcxin.risk.log.dto.dto;

import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

@Data
public class LogLoginDTO {

	/**
	 * 登陆ip
	 */
	private String ipAddress;

	/**
	 * 登陆用户
	 */
	private String userName;

	/**
	 * creat
	 */
	private String createOn;

	/**
	 * 同步时间
	 */
	private String updateOn;


	private Page page;


	public LogLoginDTO(Map<String,Object> map){
		this.userName = safeTransfor(map.get("userName"));
		this.ipAddress = safeTransfor(map.get("ipAddress"));
		this.createOn = safeTransfor(map.get("createOn"));
		this.updateOn = safeTransfor(map.get("updateOn"));
	}


	/**
	 *
	 * <b>Function 将Object安全转换为String</b>
	 *
	 * @param obj
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月22日 下午5:17:02
	 * @注意事项 </b>
	 * <b>
	 */
	private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}
}
