package com.bcxin.risk.log.dto.dto;

import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

/**
 * 文件同步标示
 */
@Data
public class FileSyncLogDTO {

	/**
	 * 同步的文件名称
	 */
	private String fileName;

	/**
	 * 同步的文件目录
	 */
	private String dir;

	/**
	 * 同步状态，默认为未同步
	 */
	private String sync;

	/**
	 * 同步时间
	 */
	private String syncTime;

	/**
	 * creat
	 */
	private String createOn;

	/**
	 * 同步时间
	 */
	private String updateOn;


	private Page page;


	public FileSyncLogDTO(Map<String,Object> map){
		this.fileName = safeTransfor(map.get("fileName"));
		this.dir = safeTransfor(map.get("dir"));
		this.sync = safeTransfor(map.get("sync"));
		this.createOn = safeTransfor(map.get("createOn"));
		this.updateOn = safeTransfor(map.get("updateOn"));
		this.syncTime = safeTransfor(map.get("syncTime"));
	}


	/**
	 *
	 * <b>Function 将Object安全转换为String</b>
	 *
	 * @param obj
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月22日 下午5:17:02
	 * @注意事项 </b>
	 * <b>
	 */
	private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}
}
