package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 用户登陆日志表
 */
@Entity
@Table(name = "log_UserLoginLog")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class UserLoginLog extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 登陆ip
	 */
	private String ipAddress;

	/**
	 * 登陆时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	private Date loginTime;

	/**
	 * 登陆用户
	 */
	private Long user_id;

}
