package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 审计操作日志
 * 需根据系统配置是否记录
 */
@Entity
@Table(name = "log_audit")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class AuditLog extends BaseBean {

    private static final long serialVersionUID = 1L;

    /**
     * 流水号
     */
    private String num_id;

    /**
     * 用户标识
     */
    private String user_id;

    /**
     * 单位名称
     */
    private String organization;

    /**
     * 用户名
     */
    private String user_name;

    /**
     * 终端标识
     */
    private String terminal_id;

    /**
     * 操作名称
     */
    private String operate_name;

    /**
     * 操作类型
     */
    private int operate_type;

    /**
     * 操作时间
     */
    private String operate_time;

    /**
     * 操作条件
     */
    private String operate_condition;

    /**
     * 操作结果
     */
    private String operate_result;
    private String bz1;
    private String bz2;
    private String bz3;
    private String bz4;
    private String bz5;
}
