package com.bcxin.risk.common.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 字典表
 * @author luopeng
 *
 */
@Entity
@Table(name = "base_dict")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Dict extends BaseBean {

	private static final long	serialVersionUID	= 1L;

	/**
	 * 类型
	 */
	private String type;

	/**
	 * 中文值
	 */
	private String label;

	/**
	 * 数字值
	 */
	private String value;

	/**
	 * 描述
	 */
	private String description;

	/**
	 * 排序
	 */
	private int sort;


}
