package com.bcxin.risk.activity.dto.data;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

@Data
public class ActivitySessionDTO {

	private String oid;
//	private String createOn;
//	private String updateOn;

	/**
	 * 活动id
	 */
	private String activityId;

	/**
	 * 开始时间
	 */
	private String startDate;

	/**
	 * 结束时间
	 */
	private String endDate;

	/**
	 * 联系人名字
	 */
	private String contactName;

	/**
	 * 联系人职务
	 */
	private String contactPosition;

	/**
	 * 联系电话
	 */
	private String contactPhone;

	/**
	 * 菜单id
	 */
	private String menuId;

	private Page page;

	public ActivitySessionDTO(){}

	public ActivitySessionDTO(Map<String,Object> map){
		this.oid = safeTransfor(map.get("oid"));
		this.activityId = safeTransfor(map.get("activityId"));
//		this.createOn = safeTransfor(map.get("createOn"));
//		this.updateOn = safeTransfor(map.get("updateOn"));
		if (StringUtil.isNotEmpty(safeTransfor(map.get("startDate")))) {
			this.startDate=safeTransfor(map.get("startDate"));
		}
		if (StringUtil.isNotEmpty(safeTransfor(map.get("endDate")))) {
			this.endDate=safeTransfor(map.get("endDate"));
		}
		this.contactName = safeTransfor(map.get("contactName"));
		this.contactPosition = safeTransfor(map.get("contactPosition"));
		this.contactPhone = safeTransfor(map.get("contactPhone"));

	}
	
	
	/**
     * 
     * <b>Function 将Object安全转换为String</b> 
     * 
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}

}
