package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.org.domain.Org;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 场地表
 */
@Entity
@Table(name = "config_venue")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert
@DynamicUpdate
public class Venue extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 省份
	 */
	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "province_id")
	private Region province ;

	/**
	 * 城市
	 */
	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "city_id")
	private Region city;

	/**
	 * 区
	 */
	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "area_id")
	private Region area;

	/**
	 * 场馆名称
	 */
	private String name;

	/**
	 * 地址
	 */
	private String address;

	/**
	 * 第三方的id
	 */
	private String toid;

	/**
	 * 是否为已录入的标准场馆，0为不是，1为是
	 */
	private String standard;

	/**
	 * 所属机构
	 */
	@ManyToOne(targetEntity = Org.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "org_id")
	private Org org;

}
