package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * <b> 活动场次表 </b>
 * @author ZXF
 * @create 2025/01/11 0011 14:32
 * @version
 * @注意事项 </b>
 */
@Entity
@Table(name = "risk_activity_session")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert
@DynamicUpdate
public class ActivitySession extends BaseBean {

	private static final long serialVersionUID = 1L;
        /**
         * 活动id
         */
        private Long activityId;

        /**
         * 开始时间
         */
        private String startDate;

        /**
         * 结束时间
         */
        private String endDate;

        /**
         * 联系人名字
         */
        private String contactName;

        /**
         * 联系人职务
         */
        private String contactPosition;

        /**
         * 联系电话
         */
        private String contactPhone;

}
