package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 活动信息表
 * @author wangjianjun
 */
@Entity
@Table(name = "risk_activity_ext")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityExt extends BaseBean {

	private static final long serialVersionUID = 1L;
        /**
         * 活动id
         */
        private Long activityId;

        /**
         * 安保公司
         */
        private String securityCompanyName;

        /**
         * 安保公司id
         */
        private String securityComId;

        /**
         * 数据状态,1已启用，0未启用
         */
        private Boolean dataStatus;

}
