package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.user.domain.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 活动信息表
 * @author 罗鹏
 */
@Entity
@Table(name = "RISK_Activity")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert
@DynamicUpdate
public class Activity extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 活动创建时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    private Date activityDate;

    /**
     * 活动名称
     */
	private String name;

    /**
     * 活动编号
     */
    private String activityNo;

    /**
     * 活动状态（字典）
     */
	private String activityStatus;

    /**
     * 初级审批状态（字典）
     */
	private String primaryStatus;

    /**
     * 承办方用户
     */
	@ManyToOne(targetEntity = User.class, fetch = FetchType.EAGER, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "user_id")
	private User user;

    /**
     * 承办方对应的机构
     */
	@ManyToOne(targetEntity = Org.class, fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "org_id")
	private Org org;

    /**
     * 公安审核状态（字典）
     */
	private String approvalStatus;

    /**
     * 公安审批意见
     */
    private String approvalContent;

    /**
     * 活动人数
     */
    private String number;

    /**
     * 活动天数
     */
    private String days;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 活动地点（室内和室外） 字典
     */
    private String addressType;

    /**
     * 室外地点（字典）
     */
    private String outDoorType;

    /**
     * 展会类型
     */
    private String exhibitionType;

    /**
     * 预计当日高峰人数
     */
    private String peakNum;

    /**
     * 是否盈利性演出（1代表是，0代表不是）
     */
    private String profitableShow;

    /**
     * 承办单位
     */
    private String sponsor;
    /**
     * 主办单位
     */
    private String zsponsor;

    /**
     * 省份
     */
    @ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "province_id")
    private Region province;

    /**
     * 市
     */
    @ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "city_id")
    private Region city;

    /**
     * 区
     */
    @ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "area_id")
    private Region area;

    /**
     * 许可单位
     */
    @ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "unit_id")
    private Region unit;

    /**
     * 活动地址，xxxx#xxxx
     */
    private String address;

    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;

    /**
     * 是否已经开始上传材料（0,代表无，1代表选择了主体（政府单位为上传了报备材料），2代表上传了详细材料）
     */
    private String postMaterial;

    /**
     * 是否是政府类项目（0,代表否，1代表是）
     */
    private String gov;

    /**
     * 是否选择了评估机构（0,代表否，1代表是）
     */
    private String chooseAssess;

    /**
     * 是否需要风评报告（政府单位的活动才有这个字段）
     */
    private String needReport;

    /**
     * 活动申请的渠道（http://sn.dh.pss360.cn,代表申报子系统陕西环境）
     */
    private String channel;

    /**
     * 历史项目标识（0,代表否，1代表是）
     */
    private String history;

    /**
     * 活动来源（字典 ActivitySource）
     */
    private String activitySource;

    /**
     * 是否备案活动，1表示政府备案活动
     */
    private String isBackUp;

    /**
     * 政务活动
     * 如：河北办件ID
     * 如：浙江政务2.0统一赋码ID
     */
    private String zwId;

    /**
     * 是否上传好差评系统
     */
    private String isPushBadGoodSystem;
    /**
     * 活动坐标
     */
    private String coordinate;
    /**
     * 活动简介
     */
    private String introduce;

}
