package com.bcxin.risk.train;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.train.domain.UserVideoProgress;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;

@Repository("userVideoProgressDao")
public class UserVideoProgressDaoImpl extends DaoImpl<UserVideoProgress> implements UserVideoProgressDao {

	@Resource
	private BaseDao baseDao;

	@Override
	public UserVideoProgress findByUserIdAndVideoId(Long userId,Long videoId) {
		SelectWrapper wrapper = SelectWrapper.instance();
		wrapper.eq("userId",userId);
		wrapper.eq("videoId",videoId);
		return selectOne(wrapper);
	}

}
