package com.bcxin.risk.policy;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.bcxin.risk.policy.dto.data.PolicyDto;
import com.bcxin.risk.policy.dto.search.PolicySearchDto;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("insurancePolicyDao")
@SuppressWarnings("unchecked")
public class InsurancePolicyDaoImpl extends DaoImpl<InsurancePolicy> implements InsurancePolicyDao {

	public InsurancePolicy findInsurancePolicyByOid(Long oid){
		return selectById(oid);
	}

	public InsurancePolicy findInsurancePolicyByExNo(String exNo) {
		List<InsurancePolicy> list = selectList(CriterionWrapper.instance().eq("externalReference", exNo));
		if(list.size()>0){
			return list.get(0);
		}
		return null;
	}

	@Override
	public List<InsurancePolicy> findInsurancePolicyList(PolicySearchDto searchDto, Page page) {
		List<Criterion> criterionList = Lists.newArrayList();
		if ( searchDto.getUser()!= null ) {
			criterionList.add(Restrictions.eq("userId", searchDto.getUser().getOid()));
		}
		if (StringUtil.isNotEmpty(searchDto.getStatus() )) {
			criterionList.add(Restrictions.eq("policyStatus", searchDto.getStatus()));
		}
		if (StringUtil.isNotEmpty(searchDto.getKeywords() )) {
			criterionList.add(Restrictions.or(Restrictions.like("externalReference", searchDto.getKeywords())
					,Restrictions.like("orderNo", searchDto.getKeywords())
					,Restrictions.like("applicantName", searchDto.getKeywords())
					,Restrictions.like("productName", searchDto.getKeywords())
					,Restrictions.like("insuranceName", searchDto.getKeywords())
					,Restrictions.like("insuranceObject", searchDto.getKeywords())));
		}

		if ( page == null ) {
			return selectList(criterionList);
		}
		return selectPage(criterionList,page);
	}

	public List<InsurancePolicy> findPolicyByUser(User user) {
		return selectList(CriterionWrapper.instance().eq("userId", user.getOid()));
	}

	/**
	 * 
	 * <b>Function 根据承办方查找活动，并转成dto</b> 
	 * 
	 * @param page
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<PolicyDto> findPolicyList(PolicySearchDto searchDto,DwzPage page){
		SelectWrapper wrapper = SelectWrapper.instance();
		String sql = "select i.oid,i.externalReference,DATE_FORMAT(i.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,i.blbOrderId" +
				",i.orderNo,i.applicantName,i.productName,i.insuranceName,i.insuranceObject,i.policyStatus,i.premium as amount "
					+" ,i.policyURL,i.invoiceURL,i.inceptionDate,i.plannedEndDate,i.signedDate,IF(i.policyStatus='6','保障中',IF(i.policyStatus='12','已失效','')) policyStatusCN"
					+" ,DATE_FORMAT(i.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn  from risk_insurancepolicy i"
					+" where 1=1 ";
		if (StringUtil.isNotEmpty(searchDto.getStartDate())){
			sql += "and i.signedDate <= '" +searchDto.getStartDate()+"' ";
		}
		if (StringUtil.isNotEmpty(searchDto.getEndDate())){
			sql += "and i.signedDate >= '" +searchDto.getEndDate()+"' ";
		}

		if(StringUtil.isNotEmpty(searchDto.getKeywords())){
			sql += "and (i.orderNo like '%"+searchDto.getKeywords()+"%' " +
					"OR i.externalReference like '%"+searchDto.getKeywords()+"%' " +
					"OR i.applicantName like '%"+searchDto.getKeywords()+"%' " +
					"OR i.productName like '%"+searchDto.getKeywords()+"%' " +
					"OR i.insuranceName like '%"+searchDto.getKeywords()+"%' " +
					"OR i.insuranceObject like '%"+searchDto.getKeywords()+"%' )";
		}
		if (StringUtil.isNotEmpty(searchDto.getStatus())){
			sql += "and i.policyStatus = '" +searchDto.getStatus()+"' ";
		}

		if(page!= null ){
			page.setTotalCount(querySqlCounts( sql,  wrapper));
			sql = sql + " ORDER BY  i.createOn DESC ,i.oid DESC limit "+(page.getPageNum() - 1) * page.getNumPerPage()+","+page.getNumPerPage()+" ";
		}
		List<PolicyDto> dtoList = Lists.newArrayList();
		List<Map<String, Object>> list = queryMaps(sql, wrapper);
		list.forEach(result -> {
			PolicyDto dto = new PolicyDto(result);
			dtoList.add(dto);
		});
		return dtoList;
	}

	@Override
	public List<PolicyDto> findPolicyByUserPage(PolicySearchDto searchDto,Page page){
		SelectWrapper wrapper = SelectWrapper.instance();
		String sql = "select i.oid,i.externalReference,DATE_FORMAT(i.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,i.blbOrderId"
				+",i.orderNo,i.applicantName,i.productName,i.insuranceName,i.insuranceObject,i.policyStatus,i.premium as amount "
				+" ,i.policyURL,i.invoiceURL,i.inceptionDate,i.plannedEndDate,i.signedDate,IF(i.policyStatus='6','保障中',IF(i.policyStatus='12','已失效','')) policyStatusCN"
				+" ,DATE_FORMAT(i.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn  from risk_insurancepolicy i"
				+" where i.userId = "+searchDto.getUser().getOid()+" ";
		if (StringUtil.isNotEmpty(searchDto.getStartDate())){
			sql += "and i.signedDate <= '" +searchDto.getStartDate()+"' ";
		}
		if (StringUtil.isNotEmpty(searchDto.getEndDate())){
			sql += "and i.signedDate >= '" +searchDto.getEndDate()+"' ";
		}
		if(StringUtil.isNotEmpty(searchDto.getKeywords())){
			sql += "and (i.orderNo like '%"+searchDto.getKeywords()+"%' " +
					"OR i.externalReference like '%"+searchDto.getKeywords()+"%' " +
					"OR i.applicantName like '%"+searchDto.getKeywords()+"%' " +
					"OR i.productName like '%"+searchDto.getKeywords()+"%' " +
					"OR i.insuranceName like '%"+searchDto.getKeywords()+"%' " +
					"OR i.insuranceObject like '%"+searchDto.getKeywords()+"%' )";
		}
		if (StringUtil.isNotEmpty(searchDto.getStatus())){
			sql += "and i.policyStatus = '" +searchDto.getStatus()+"' ";
		}
		wrapper.orderBy(" i.createOn",false);
		wrapper.orderBy(" i.oid",false);

		List<PolicyDto> dtoList = Lists.newArrayList();
		Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper,page);
		List<Map<String, Object>> list = pageList.getRecords();
		list.forEach(result -> {
			PolicyDto dto = new PolicyDto(result);
			dto.setPage(page);
			dtoList.add(dto);
		});
		return dtoList;
	}

	@Override
	public void closeExpirePolicy() {
		String sql = "UPDATE risk_insurancepolicy SET policyStatus = '12',updateOn = NOW() WHERE policyStatus = '6' AND DATE_ADD(plannedEndDate, INTERVAL 1 DAY) < NOW() ";
		executeSqlUpdate(sql);
	}

	@Override
	public void updateSyncStatus(String externalReference) {
		String sql = "UPDATE risk_insurancepolicy SET isSync = 1,updateOn = NOW() WHERE externalReference = '"+externalReference+"'";
		executeSqlUpdate(sql);
	}

	@Override
	public List<PolicyDto> findUnSyncPolicyList(){
		SelectWrapper wrapper = SelectWrapper.instance();
		String sql = "select userId,externalReference from risk_insurancepolicy where policyStatus = '6' and isSync = 0";


		List<PolicyDto> dtoList = Lists.newArrayList();
		List<Map<String, Object>> list = queryMaps(sql, wrapper);
		list.forEach(result -> {
			PolicyDto dto = new PolicyDto(result);
			dtoList.add(dto);
		});
		return dtoList;
	}
}
