package com.bcxin.risk.common.dao;

import com.bcxin.risk.common.domain.BusinessOwnership;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by PVer on 2017/4/24.
 */
@Repository
public class BusinessOwnershipDaoImpl extends DaoImpl<BusinessOwnership> implements BusinessOwnershipDao{


    @Override
    public List<BusinessOwnership> selectBusinessOwnershipList(){
        Order[] orders = new Order[1];
        orders[0] = Order.asc("oid");
        return selectList(orders);
    }

    @Override
    public BusinessOwnership findBusinessOwnershipByOid(Long oid){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("oid",oid);
        wrapper.eq("active",DictConst.Y);
        return  selectById(oid);
    }

}
