package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public class ActivityOtherOrderDaoImpl extends DaoImpl<ActivityOtherOrder> implements ActivityOtherOrderDao {

    @Override
    public List<ActivityOtherOrder> activityOtherOrderList() {
        return selectList();
    }


    @Override
    public List<ActivityOtherOrder> findActivityOtherOrder(String activityNo, List<String> productCodes,String status) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("activityNo", activityNo);
        if(productCodes != null && productCodes.size()>0){
            wrapper.in("productCode", productCodes);
        }
        if(StringUtil.isEmpty(status)){
            wrapper.notIn("status", "9");
        }else{
            wrapper.eq("status", status);
        }
        return selectList(wrapper);
    }
    @Override
    public ActivityOtherOrder findActivityOtherOrderByOrderNo(String orderNo) {
        return selectOne(SelectWrapper.instance().eq("orderNo", orderNo));
    }

    @Override
    public List<ActivityOtherOrder> findActivityOtherOrderByUserId(String userId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("userId", userId);
        wrapper.isNotNull("activityNo");
        return selectList(wrapper);
    }
    @Override
    public List<ActivityOtherOrder> findActivityOtherOrderByActivityName(String activityName) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("activityName", activityName);
        return selectList(wrapper);
    }


    @Override
    public ActivityOtherOrder findActivityOtherOrderByOid(Long oid) {
        return selectById(oid);
    }


}
