package com.bcxin.risk.activity;

import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public class ActivityGradeRankDaoImpl extends DaoImpl<ActivityGradeRank> implements ActivityGradeRankDao{

    @Override
    public List<ActivityGradeRank> selectListByActivity(Activity activity) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null ) {
            criterionList.add(Restrictions.eq("activity", activity));
        }
        Order order = Order.desc("createOn");
        return selectList(criterionList,order);
    }

    @Override
    public List<ActivityGradeRank> selectPoliceSupply(Activity activity) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("activity", activity));
        criterionList.add(Restrictions.eq("gradeRankType", DictConst.GRADERANKTYPE_CL));
        criterionList.add(Restrictions.eq("opStatus", DictConst.N));
        return selectList(criterionList);
    }

    @Override
    public void updateOpStatus(Activity activity,String gradeRankType){
        //UpdateWrapper wrapper = new UpdateWrapper();
        //wrapper.eq("activity",activity);
        //wrapper.eq("gradeRankType",DictConst.GRADERANKTYPE_CL);
        //wrapper.set("isCommit", DictConst.Y);
        //update(wrapper);
        String sql = "UPDATE RISK_Activity_Grade_Rank " +
                " SET opStatus ='1' " +
                " WHERE activity_id = " + activity.getOid() + "" +
                " and gradeRankType = " + gradeRankType;
        executeSqlUpdate(sql);
    }
}
