package com.bcxin.risk.activity;

import cn.hutool.core.date.DateUtil;
import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.activity.dto.search.ActivitySearchDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.dto.search.ParamDTO;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.common.util.ObjectUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.hibernateplus.utils.CollectionUtils;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository
public class ActivityCostDaoImpl extends DaoImpl<ActivityCost> implements ActivityCostDao {

    @Override
    public List<ActivityCost> activityCostList() {
        return selectList();
    }


    @Override
    public ActivityCost findActivityCostByActivityNo(String activityNo) {
        return selectOne(SelectWrapper.instance().eq("activityNo", activityNo));
    }

    @Override
    public List<ActivityCost> findActivityCostByUserId(String userId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("userId", userId);
        wrapper.isNotNull("activityNo");
        return selectList(wrapper);
    }

    @Override
    public ActivityCost getActivityCostBySomeWhere(String userId,String skuId,String activityName,String serverOrg) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("userId", userId);
        wrapper.eq("skuId", skuId);
        wrapper.eq("activityName", activityName);
        wrapper.eq("serverOrg", serverOrg);
        wrapper.isNull("activityNo");
        List<ActivityCost> list = selectList(wrapper);
        if(list.size()>0){
            return list.get(0);
        }
        return null;
    }
    @Override
    public List<ActivityCost> findActivityCostByActivityName(String activityName) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("activityName", activityName);
        return selectList(wrapper);
    }


    @Override
    public ActivityCost findActivityCostByOid(Long oid) {
        return selectById(oid);
    }


}
