package com.bcxin.risk.activity;

import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public class ActivityCooperateFileDaoImpl extends DaoImpl<ActivityCooperateFile> implements ActivityCooperateFileDao{

    @Override
    public List<ActivityCooperateFile> selectListByActivity(Activity activity) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null ) {
            criterionList.add(Restrictions.eq("activity", activity));
        }
        Order order = Order.desc("createOn");
        return selectList(criterionList,order);
    }

    @Override
    public List<ActivityCooperateFile> selectPoliceSupply(Activity activity) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("activity", activity));
        criterionList.add(Restrictions.eq("opStatus", DictConst.Y));
        return selectList(criterionList);
    }

    @Override
    public void updateOpStatus(Long oid,String opStatus){
        String sql = "UPDATE RISK_Activity_Cooperate_File " +
                " SET opStatus ='"+opStatus+"' " +
                " WHERE oid = '" + oid + "'" ;
        executeSqlUpdate(sql);
    }
}
