/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.report.material;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.dto.data.MaterialFormValueDTO;
import com.bcxin.risk.report.dto.search.MaterialFormValueSearchDTO;
import com.bcxin.risk.report.material.dao.MaterialFormValueDao;
import com.bcxin.risk.report.material.domain.MaterialFormAttr;
import com.bcxin.risk.report.material.domain.MaterialFormMenu;
import com.bcxin.risk.report.material.domain.MaterialFormValue;
import com.bcxin.risk.report.material.dto.MaterialComposeValueDTO;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class MaterialFormValueDaoImpl
extends DaoImpl<MaterialFormValue>
implements MaterialFormValueDao {
    public MaterialFormValue findByActivityAttr(Activity activity, MaterialFormAttr attr, int seq) {
        Criteria criteria = this.createCriteria(MaterialFormValue.class).add((Criterion)Restrictions.eq((String)"activity", (Object)activity)).add((Criterion)Restrictions.eq((String)"attr", (Object)attr)).add((Criterion)Restrictions.eq((String)"seq", (Object)seq));
        Object result = criteria.uniqueResult();
        if (result == null) {
            return null;
        }
        return (MaterialFormValue)result;
    }

    public MaterialFormValue findByOid(Long oid) {
        return (MaterialFormValue)this.selectById(oid);
    }

    public List<MaterialFormValue> findByActivityAttr(Activity activity, MaterialFormAttr attr) {
        Criteria criteria = this.createCriteria(MaterialFormValue.class).add((Criterion)Restrictions.eq((String)"activity", (Object)activity)).add((Criterion)Restrictions.eq((String)"attr", (Object)attr));
        criteria.addOrder(Order.asc((String)"seq"));
        return criteria.list();
    }

    public List<String> findByActivityAttr(Activity activity, String attrCode) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select v.value from risk_materialformvalue v   inner join risk_materialformattr a on a.oid = v.attr_id ";
        wrapper.eq("v.activity_id", (Object)activity.getOid());
        wrapper.eq("a.attrCode", (Object)attrCode);
        wrapper.orderBy("v.seq");
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        ArrayList valueList = Lists.newArrayList();
        if (list == null) {
            return valueList;
        }
        list.forEach(result -> valueList.add(result.get("value") == null ? "" : result.get("value").toString()));
        return valueList;
    }

    public List<MaterialFormValueDTO> findDTOByActivityAttrs(Long activityId, List<String> attrCodes) {
        String attrCodeStr = Joiner.on((String)",").skipNulls().join(attrCodes);
        attrCodeStr = attrCodeStr.replaceAll(",", "','");
        attrCodeStr = "'" + attrCodeStr + "'";
        String sql = "select a.attrCode,a.type as attrType, a.optionType as optionType,v.value,v.seq  from risk_materialformvalue v  inner join risk_materialformattr a on v.attr_id = a.oid  where v.activity_id = " + activityId + " and a.attrCode in (" + attrCodeStr + ")";
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql.toString());
        list.forEach(result -> {
            Map map = result;
            MaterialFormValueDTO dto = new MaterialFormValueDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<MaterialFormValue> findByActivity(Activity activity) {
        Criteria criteria = this.createCriteria(MaterialFormValue.class).add((Criterion)Restrictions.eq((String)"activity", (Object)activity));
        return criteria.list();
    }

    public List<MaterialFormValue> findByActivityAndAttrs(Activity activity, List<MaterialFormAttr> attrList) {
        Criteria criteria = this.createCriteria(MaterialFormValue.class).add((Criterion)Restrictions.eq((String)"activity", (Object)activity)).add(Restrictions.in((String)"attr", attrList));
        return criteria.list();
    }

    public List<MaterialFormValueDTO> findByActivity(MaterialFormValueSearchDTO searchDTO) {
        String sql = "select v.oid,v.value,a.oid as attrId,v.seq,a.attrCode,a.type as attrType,a.optionType from risk_materialformvalue v inner join risk_materialformattr a on v.attr_id = a.oid ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (searchDTO.getActivity() == null) {
            return Lists.newArrayList();
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getMenuId())) {
            wrapper.eq("a.menu_id", (Object)searchDTO.getMenuId());
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getSeq())) {
            wrapper.eq("v.seq", (Object)searchDTO.getSeq());
        }
        wrapper.eq("v.activity_id", (Object)searchDTO.getActivity().getOid());
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            MaterialFormValueDTO dto = new MaterialFormValueDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<MaterialComposeValueDTO> findByReport(Long report_id) {
        String sql = "select c.classCode,c.className,a.attrCode,m.menuName,m.modify, (case when v.seq >= 1 then CONCAT('\uff08\u7b2c',v.seq+1,'\u4e2a\u4e3b\u4f53\uff09',attrName) else a.attrName end)  attrName,  a.type as attrType,a.optionType,v.`value`  from config_materialformclass c  inner join risk_materialformmenu m on m.class_id = c.oid  inner join risk_materialformattr a on a.menu_id = m.oid  inner join risk_materialformvalue v on v.attr_id = a.oid  inner join risk_report r on r.activity_id = m.activity_id ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (report_id == null) {
            return Lists.newArrayList();
        }
        wrapper.eq("r.oid", (Object)report_id);
        wrapper.orderBy("v.seq,v.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            MaterialComposeValueDTO dto = new MaterialComposeValueDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<MaterialFormValueDTO> findMultiSeqByActivity(MaterialFormValueSearchDTO searchDTO) {
        String sql = "select DISTINCT v.seq from risk_materialformvalue v  inner join risk_materialformattr a on v.attr_id = a.oid ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (searchDTO.getActivity() == null) {
            return Lists.newArrayList();
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getMenuId())) {
            wrapper.eq("a.menu_id", (Object)searchDTO.getMenuId());
        }
        wrapper.eq("a.activity_id", (Object)searchDTO.getActivity().getOid());
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            MaterialFormValueDTO dto = new MaterialFormValueDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public int deleteByActivityAndAttrs(Activity activity, List<Long> attrIds, int seq) {
        DeleteWrapper wrapper = DeleteWrapper.instance();
        if (activity == null) {
            return 0;
        }
        wrapper.eq("activity_id", (Object)activity.getOid());
        wrapper.in("attr_id", attrIds);
        wrapper.eq("seq", (Object)seq);
        return this.delete((Wrapper)wrapper);
    }

    public int findMaxSeq(Activity activity, MaterialFormMenu materialFormMenu) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (activity == null || materialFormMenu == null) {
            return 0;
        }
        String sql = "select max(v.seq) from RISK_MaterialFormValue v inner join risk_materialFormAttr a on a.oid = v.attr_id  inner join risk_materialFormMenu m on m.oid = a.menu_id ";
        wrapper.eq("v.activity_id", (Object)activity.getOid());
        wrapper.eq("m.oid", (Object)materialFormMenu.getOid());
        return this.queryAggregate(sql, (Wrapper)wrapper);
    }

    public List<MaterialFormValueDTO> findMultiFormValues(Activity activity, MaterialFormMenu menu, String ignoreSeq) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("select a.oid as attrId,a.attrCode,a.attrName,a.type as attrType,v.seq,v.`value`,a.optionType from risk_MaterialFormValue v  inner join risk_materialformattr a on a.oid = v.attr_Id  inner join risk_materialformmenu m on m.oid = a.menu_id ");
        if (activity == null || menu == null) {
            return Lists.newArrayList();
        }
        wrapper.eq("m.oid", (Object)menu.getOid());
        wrapper.eq("v.activity_id", (Object)activity.getOid());
        if (StringUtil.isNotEmpty((String)ignoreSeq)) {
            wrapper.gt("v.seq", (Object)(Integer.parseInt(ignoreSeq) - 1));
        } else {
            wrapper.gt("v.seq", (Object)0);
        }
        wrapper.orderBy("a.seq");
        wrapper.orderBy("a.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql.toString(), (Wrapper)wrapper);
        list.forEach(result -> {
            Map map = result;
            MaterialFormValueDTO dto = new MaterialFormValueDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<MaterialFormValueDTO> findMultiOrgValues(Activity activity, String menuCode) {
        if (activity == null || StringUtil.isEmpty((String)menuCode)) {
            return Lists.newArrayList();
        }
        StringBuffer sql = new StringBuffer("SELECT b.oid as orgId,c.menuCode FROM risk_activity_cooper a , risk_serviceorg b ,risk_materialformorg c WHERE a.org_id = b.oid  AND b.serviceOrgType = c.orgType and a.activity_id = " + activity.getOid() + " and c.menuCode = '" + menuCode + "'");
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql.toString());
        list.forEach(result -> {
            Map map = result;
            MaterialFormValueDTO dto = new MaterialFormValueDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public void updateValue(String value, Long oid) {
        String sql = "update risk_materialformvalue set value = '" + value + "' , updateOn = SYSDATE() where oid = " + oid;
        this.executeSqlUpdate(sql);
    }

    public void deleteByActivityId(Long activityId) {
        String sql = "delete from risk_materialformvalue where activity_id = " + activityId;
        this.executeSqlUpdate(sql);
    }

    public List<Map<String, Object>> selectFormValueMap(Long activityId, Long menuId) {
        String sql = "select B.menu_id as menuId,CONCAT(B.attrCode,'-',C.seq) as attrCode,B.attrName,C.`value`,B.type as attrType,IFNULL(B.optionType,'') as optionType  from risk_materialformmenu A,risk_materialformattr B ,risk_materialformvalue C  where A.oid=B.menu_id and B.oid=C.attr_id and C.activity_id=" + activityId + " and B.menu_id=" + menuId + " ORDER BY B.attrCode,C.seq";
        List list = this.queryMaps(sql.toString());
        return list;
    }
}

