/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity;

import cn.hutool.core.date.DateUtil;
import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.ActivityDao;
import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.activity.dto.search.ActivitySearchDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.dto.search.ParamDTO;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.common.util.ObjectUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.hibernateplus.utils.CollectionUtils;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityDaoImpl
extends DaoImpl<Activity>
implements ActivityDao {
    public List<Activity> activityList() {
        return this.selectList();
    }

    public Activity findActivityByActivityNo(String activityNo) {
        return (Activity)this.selectOne(SelectWrapper.instance().eq("activityNo", (Object)activityNo));
    }

    public List<Activity> findUnendActivity(String userId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("user_id", (Object)userId);
        wrapper.gt("startDate", (Object)DateUtil.formatDateTime((Date)new Date()));
        wrapper.notIn("activityStatus", (Collection)Lists.newArrayList((Object[])new String[]{"0"}));
        return this.selectList((Wrapper)wrapper);
    }

    public List<Activity> findActivityByActivityName(String activityName, String filterId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("name", (Object)activityName);
        if (StringUtil.isNotEmpty((String)filterId)) {
            wrapper.notIn("oid", filterId);
        }
        wrapper.notIn("activityStatus", (Collection)Lists.newArrayList((Object[])new String[]{"88", "0"}));
        return this.selectList((Wrapper)wrapper);
    }

    public Activity findActivityByOid(Long oid) {
        return (Activity)this.selectById(oid);
    }

    public List<ActivityDataDTO> findActivityDtoList(ActivitySearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (searchDto != null) {
            if (searchDto.getActivityStatus() != null) {
                wrapper.eq("activityStatus", (Object)searchDto.getActivityStatus());
            }
            if (searchDto.getSponsor() != null) {
                wrapper.like("sponsor", searchDto.getSponsor());
            }
            if (searchDto.getOrderNo() != null) {
                wrapper.eq("orderNo", (Object)searchDto.getOrderNo());
            }
            if (searchDto.getStarttime() != null) {
                wrapper.ge("createOn", (Object)DateUtil.parseDate((CharSequence)searchDto.getStarttime()));
            }
            if (searchDto.getEndtime() != null) {
                wrapper.le("endDate", (Object)DateUtil.parseDate((CharSequence)searchDto.getEndtime()));
            }
            if (searchDto.getUser() != null) {
                wrapper.eq("user", (Object)searchDto.getUser());
            }
            if (searchDto.getActivityType() != null) {
                wrapper.eq("activityType", (Object)searchDto.getActivityType());
            }
            if (StringUtil.isNotEmpty((String)searchDto.getName())) {
                wrapper.like("name", searchDto.getName());
            }
        }
        wrapper.orderBy("updateOn", false);
        wrapper.orderBy("oid", false);
        List list = Lists.newArrayList();
        if (page == null) {
            list = this.queryMaps("select * from risk_activity ", (Wrapper)wrapper);
        } else {
            Page rpage = this.queryMapsPage("select * from risk_activity ", (Wrapper)wrapper, page);
            list = rpage.getRecords();
        }
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map map = result;
            ActivityDataDTO dto = new ActivityDataDTO(map);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public Map<String, String> countActivity(ActivitySearchDTO dto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuilder sql = new StringBuilder("select  sum(case r.activityStatus when '50' then 1 else 0 end) as complete, sum(case r.activityStatus when '50' then 0 else 1 end) as uncomplete from risk_activity r ");
        if (dto.getUser() == null) {
            return Maps.newHashMap();
        }
        wrapper.eq("user_id", (Object)dto.getUser().getOid());
        HashMap countMap = Maps.newHashMap();
        Map result = this.queryMap(sql.toString(), (Wrapper)wrapper);
        countMap.put("complete", result.get("complete") == null ? "0" : result.get("complete").toString());
        countMap.put("uncomplete", result.get("uncomplete") == null ? "0" : result.get("uncomplete").toString());
        return countMap;
    }

    public List<ActivityDataDTO> findActivityByApprovalStatus(ActivitySearchDTO activitySearchDTO, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select  DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn, a.oid,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn, p.province AS province , c.city AS city , area.area AS area , a.`name` AS name , a.activitySource , a.address AS address, a.sponsor AS sponsor , a.approvalStatus AS approvalStatus , a.primaryStatus , a.activityStatus AS activityStatus , a.oid AS activityId , a.startDate AS startDate , a.endDate AS endDate  from risk_activity a  inner join base_region p on p.oid = a.province_id  left join base_region c on c.oid = a.city_id  left join base_region area on area.oid = a.area_id where 1=1 and a.activityStatus != 88";
        if (StringUtil.isNotEmpty((String)activitySearchDTO.getProvince())) {
            sql = sql + " and a.province_id = '" + activitySearchDTO.getProvince() + "' ";
        }
        if (StringUtil.isNotEmpty((String)activitySearchDTO.getCity())) {
            sql = sql + " and a.city_id = '" + activitySearchDTO.getCity() + "' ";
        }
        if (StringUtil.isNotEmpty((String)activitySearchDTO.getArea())) {
            sql = sql + " and a.area_id  = '" + activitySearchDTO.getArea() + "' ";
        }
        wrapper.orderBy("a.createOn", false);
        wrapper.orderBy("a.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ActivityDataDTO> activityDataDTOList(ParamDTO paramDTO, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT  a.oid ,a.name,a.activitySource,a.history,a.activityNo,DATE_FORMAT(a.activityDate,'%Y-%m-%d %H:%i:%s') AS activityDate,a.activityType, a.activityStatus,a.primaryStatus,a.gov, a.isBackUp, a.postMaterial, a.needReport, (SELECT value FROM risk_activityMaterial WHERE activityMaterialType = '1' AND activity_id = a.oid) AS pgbgUrl, IF((SELECT COUNT(1)    FROM risk_activityMaterial   WHERE activityMaterialType = '1' AND activity_id = a.oid ) =0 ,'0','1') AS isExistsPgbg , a.province_id as province, a.city_id as city, a.area_id as area, a.startDate, a.endDate, a.address, a.sponsor, u.companyPhone  FROM risk_activity a  INNER JOIN risk_se_user u on  u.oid = a.user_id  where 1=1 and a.activityStatus != '88' ";
        if (paramDTO.getUser() != null) {
            sql = sql + " and u.oid = " + paramDTO.getUser().getOid() + " ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getKeyname())) {
            sql = sql + " and a.name like '%" + paramDTO.getKeyname() + "%' ";
        }
        if ("1".equalsIgnoreCase(paramDTO.getProcess())) {
            sql = sql + " and a.activityStatus not in (50) ";
        }
        if ("0".equalsIgnoreCase(paramDTO.getProcess())) {
            sql = sql + " and a.activityStatus = '50' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getIsBackUp())) {
            sql = sql + " and a.isBackUp = '" + paramDTO.getIsBackUp() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getActivityType())) {
            sql = sql + " and a.activityType = '" + paramDTO.getActivityType() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getStartDate())) {
            sql = sql + " and a.startDate >= '" + paramDTO.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getEndDate())) {
            sql = sql + " and a.startDate <= '" + paramDTO.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getActivityStatus())) {
            String activityStatus;
            if (paramDTO.getActivityStatus().startsWith("C")) {
                activityStatus = CharMatcher.digit().retainFrom((CharSequence)paramDTO.getActivityStatus());
                if (activityStatus.equals("0")) {
                    sql = sql + " AND (a.activityStatus in ('10','15','20','25') ";
                    sql = sql + " AND a.primaryStatus IN ('10','20','30','SL10','SL30') OR (ISNULL(a.primaryStatus) AND a.activityStatus ='10') ) ";
                } else {
                    sql = activityStatus.equals("1") ? sql + " and a.activityStatus = '50' " : sql + " and a.activityStatus = '" + activityStatus + "' ";
                }
            } else if (paramDTO.getActivityStatus().startsWith("G")) {
                activityStatus = CharMatcher.digit().retainFrom((CharSequence)paramDTO.getActivityStatus());
                sql = sql + " and a.activityStatus = '" + activityStatus + "' ";
            }
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getActivitySource())) {
            sql = sql + " and a.activitySource = '" + paramDTO.getActivitySource() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getProvince())) {
            sql = sql + " and a.province_id = '" + paramDTO.getProvince() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getCity())) {
            sql = sql + " and a.city_id = '" + paramDTO.getCity() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getArea())) {
            sql = sql + " and a.area_id = '" + paramDTO.getArea() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getProfile())) {
            sql = sql + " and a.province_id = '" + paramDTO.getProfile() + "' ";
        }
        wrapper.orderBy("a.createOn", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            if (StringUtils.isNotBlank((CharSequence)paramDTO.getProfile())) {
                dto.setProvince(ConfigUtil.getRegion((String)dto.getProvince()));
            }
            dto.setCity(ConfigUtil.getRegion((String)dto.getCity()));
            dto.setArea(ConfigUtil.getRegion((String)dto.getArea()));
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ActivityDataDTO> pgbgDataDTOList(ParamDTO paramDTO, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT  a.oid ,a.name,a.activityNo,DATE_FORMAT(a.activityDate,'%Y-%m-%d %H:%i:%s') AS activityDate,m.value AS pgbgUrl  FROM risk_activity a  INNER JOIN risk_activityMaterial m on  m.activity_id = a.oid and m.activityMaterialType = '1' INNER JOIN risk_se_user u on  u.oid = a.user_id  where 1=1 and a.activityStatus != '88' ";
        if (paramDTO.getUser() != null) {
            sql = sql + " and u.oid = " + paramDTO.getUser().getOid() + " ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getKeyname())) {
            sql = sql + " and a.name like '%" + paramDTO.getKeyname() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getStartDate())) {
            sql = sql + " and a.startDate >= '" + paramDTO.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getEndDate())) {
            sql = sql + " and a.startDate <= '" + paramDTO.getEndDate() + "' ";
        }
        sql = sql + " and m.value IS NOT NULL ";
        wrapper.orderBy("a.createOn", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ActivityDataDTO> activityServiceOrgDataDTOList(ParamDTO paramDTO, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT  a.oid ,a.name,a.activitySource,a.history,a.activityNo,DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,a.activityType, a.activityStatus,a.primaryStatus,a.gov, a.isBackUp, a.postMaterial, a.needReport, IF((SELECT COUNT(1)    FROM risk_activityMaterial   WHERE activityMaterialType = '1' AND activity_id = a.oid ) =0 ,'0','1') AS isExistsPgbg , a.province_id as province, a.city_id as city, a.area_id as area, a.startDate, a.endDate, a.address, a.sponsor, u.companyPhone, ext.dataStatus,  ifnull(ext.securityCompanyName,'\u65e0') as securityCompanyName,  ifnull(ext.securityComId,'\u65e0') as securityComId  FROM risk_activity a  INNER JOIN risk_se_user u on  u.oid = a.user_id  left join (select * from risk_activity_ext group by activityId) ext on ext.activityId = a.oid  where 1=1 and a.activityStatus != '88' ";
        if (paramDTO.getUser() != null) {
            sql = sql + " and u.oid = " + paramDTO.getUser().getOid() + " ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getKeyname())) {
            sql = sql + " and a.name like '%" + paramDTO.getKeyname() + "%' ";
        }
        if ("1".equalsIgnoreCase(paramDTO.getProcess())) {
            sql = sql + " and a.activityStatus not in (50) ";
        }
        if ("0".equalsIgnoreCase(paramDTO.getProcess())) {
            sql = sql + " and a.activityStatus = '50' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getIsBackUp())) {
            sql = sql + " and a.isBackUp = '" + paramDTO.getIsBackUp() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getActivityType())) {
            sql = sql + " and a.activityType = '" + paramDTO.getActivityType() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getStartDate())) {
            sql = sql + " and a.startDate >= '" + paramDTO.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getEndDate())) {
            sql = sql + " and a.startDate <= '" + paramDTO.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getActivityStatus())) {
            String activityStatus;
            if (paramDTO.getActivityStatus().startsWith("C")) {
                activityStatus = CharMatcher.digit().retainFrom((CharSequence)paramDTO.getActivityStatus());
                if (activityStatus.equals("0")) {
                    sql = sql + " AND (a.activityStatus in ('10','15','20','25') ";
                    sql = sql + " AND a.primaryStatus IN ('10','20','30','SL10','SL30') OR (ISNULL(a.primaryStatus) AND a.activityStatus ='10') ) ";
                } else {
                    sql = activityStatus.equals("1") ? sql + " and a.activityStatus = '50' " : sql + " and a.activityStatus = '" + activityStatus + "' ";
                }
            } else if (paramDTO.getActivityStatus().startsWith("G")) {
                activityStatus = CharMatcher.digit().retainFrom((CharSequence)paramDTO.getActivityStatus());
                sql = sql + " and a.activityStatus = '" + activityStatus + "' ";
            }
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getActivitySource())) {
            sql = sql + " and a.activitySource = '" + paramDTO.getActivitySource() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getProvince())) {
            sql = sql + " and a.province_id = '" + paramDTO.getProvince() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getCity())) {
            sql = sql + " and a.city_id = '" + paramDTO.getCity() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getArea())) {
            sql = sql + " and a.area_id = '" + paramDTO.getArea() + "' ";
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getProfile())) {
            sql = sql + " and a.province_id = '" + paramDTO.getProfile() + "' ";
        }
        wrapper.orderBy("a.createOn", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            if (StringUtils.isNotBlank((CharSequence)paramDTO.getProfile())) {
                dto.setProvince(ConfigUtil.getRegion((String)dto.getProvince()));
            }
            dto.setCity(ConfigUtil.getRegion((String)dto.getCity()));
            dto.setArea(ConfigUtil.getRegion((String)dto.getArea()));
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public void cancelActivity(Long activityId) {
        String sql = "UPDATE risk_activity SET activityStatus = '0' WHERE  oid = " + activityId;
        this.executeSqlUpdate(sql);
    }

    public List listActivity(DwzPage page, ActivitySearchDTO searchDTO) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT a.*,b.activityType,c.city from risk_activity a  INNER JOIN base_region c  ON a.city_id =c.oid ";
        if (StringUtil.isNotEmpty((String)searchDTO.getSponsor())) {
            sql = sql + " AND a.sponsor like '%" + searchDTO.getSponsor() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getActivityNo())) {
            sql = sql + " AND a.activityNo like '%" + searchDTO.getActivityNo() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getActivityStatus())) {
            sql = sql + " AND a.activityStatus =" + searchDTO.getActivityStatus();
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getStartDate())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') >= '" + searchDTO.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getEndDate())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') <= '" + searchDTO.getEndDate() + "' ";
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " ORDER BY oid DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List<Map<String, Object>> listMaterialPath(String oid, String activityMaterialType) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT `value` FROM risk_activitymaterial WHERE activityMaterialType  = " + activityMaterialType + " AND activity_id = " + oid;
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public void updatePushSignForGoodBadComment(Long activityId) {
        String sql = "UPDATE risk_activity SET isPushBadGoodSystem = '1' WHERE  oid = " + activityId;
        this.executeSqlUpdate(sql);
    }

    public List<Activity> findNotPushForGoodBadComment() {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("isPushBadGoodSystem", (Object)"0");
        wrapper.isNotNull("zwId");
        return this.selectList((Wrapper)wrapper);
    }

    public boolean isExist(String zwId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("zwId", (Object)zwId);
        List list = this.selectList((Wrapper)wrapper);
        return list.size() > 0;
    }

    public String selectLastActivityProjId(String areaCode) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select zwId from risk_activity where createOn > CONCAT('" + DateUtil.today() + "',' 00:00:00') and area_id = " + areaCode + " order by zwId desc limit 1";
        List maps = this.queryMaps(sql, (Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)maps)) {
            return "";
        }
        return ObjectUtil.safeTransfor(((Map)maps.get(0)).get("zwId"));
    }

    public Activity findActivityByZwId(String zwId) {
        return (Activity)this.selectOne(SelectWrapper.instance().eq("zwId", (Object)zwId));
    }
}

