/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util.sms;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HttpConfig {
    protected static final String METHOD_GET = "GET";
    protected static final String METHOD_POST = "POST";
    protected static final String DEFAULT_CHARSET = "utf-8";
    public static final String CONTENT_TYPE_XML = "text/xml";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_TXT = "text/plain";
    public static final String CONTENT_TYPE_HTML = "text/html";
    private static int readTimeout = 10000;
    private static int connectTimeout = 30000;

    protected HttpURLConnection getConnection(URL url, String method, String ctype) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("User-Agent", "stargate");
        conn.setRequestProperty("Connection", "Keep-Alive");
        if (this.StrNotNull(ctype)) {
            conn.setRequestProperty("Content-Type", ctype);
        }
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
        return conn;
    }

    protected String getResponseAsString(HttpURLConnection conn) throws IOException {
        InputStream es = null;
        InputStream is = null;
        try {
            es = conn.getErrorStream();
            is = conn.getInputStream();
            String charset = this.getResponseCharset(conn.getContentType());
            if (es == null) {
                String string = this.getStreamAsString(conn.getInputStream(), charset);
                return string;
            }
            String msg = this.getStreamAsString(es, charset);
            if (!this.StrNotNull(msg)) {
                throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
            }
            throw new IOException(msg);
        }
        finally {
            if (null != es) {
                es.close();
            }
            if (null != is) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getResponseAsByteArray(HttpURLConnection conn) throws IOException {
        InputStream is = null;
        try {
            is = conn.getInputStream();
            String ctype = conn.getContentType();
            if (!this.StrNotNull(ctype)) {
                throw new IOException("io\u5f02\u5e38");
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                output.write(buffer, 0, n);
            }
            output.flush();
            byte[] fileContent = output.toByteArray();
            output.close();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", fileContent);
            result.put("type", ctype);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (null != is) {
                is.close();
            }
        }
    }

    protected String getStreamAsString(InputStream stream, String charset) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
        StringWriter writer = new StringWriter();
        char[] chars = new char[256];
        int count = 0;
        while ((count = reader.read(chars)) > 0) {
            writer.write(chars, 0, count);
        }
        return writer.toString();
    }

    protected String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (this.StrNotNull(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || !this.StrNotNull(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    private boolean StrNotNull(String str) {
        return str != null && !"".equals(str);
    }
}

