package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 菜单
 */
@Entity
@Table(name = "base_menu")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Menu extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 父菜单
	 */
	@ManyToOne(targetEntity = Menu.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "parent_id")
	private Menu parent;

	/**
	 * 编码规则 01 0101 010101
	 */
	private String menuCode;

	/**
	 * 菜单名称
	 */
	private String menuName;

	/**
	 * 菜单描述
	 */
	private String menuDesc;

	/**
	 * 菜单类型
	 */
	private String menuType;
	
}
