package com.bcxin.risk.train.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

@Entity
@Table(name = "sys_video")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Video extends BaseBean {
	
	private static final long serialVersionUID = 1L;

	/**
	 * 承办方课程
	 */
	private String courseType;

	/**
	 * 视频标题
	 */
	private String title;

	/**
	 * 视频封面
	 */
	private String cover;

	/**
	 * 视频简介
	 */
	private String description;

	/**
	 * 视频链接
	 */
	private String linkUrl;

	/**
	 * 试题测试url
	 */
	private String testUrl;

}
