package com.bcxin.risk.train.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

@Entity
@Table(name = "risk_user_video_progress")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class UserVideoProgress extends BaseBean {
	
	private static final long serialVersionUID = 1L;

	/**
	 * 节id
	 */
	private Long videoId;

	/**
	 * 用户id
	 */
	private Long userId;

	/**
	 * 是否完成
	 */
	private String completed;

}
