package com.bcxin.risk.report.enums;


public enum SurveyTaskStatus {
	
//	新任务：未作出“接受”或“拒绝”反馈的任务
//	进行中：已做出反馈，未完成勘查的任务；
//	已拒绝：做出“拒绝”反馈的任务
//	已办结：已完成勘查的任务
//	已转交：转交给其他客户经理的任务
	
	/** 派发 */
	DISTRIBUTE {public String getValue(){return "0";} public String getName(){return "新任务";}}, 
	/** 接受超时 */
	OVERTIME {public String getValue(){return "2";} public String getName(){return "超时";}}, 
	/** 进行中*/
	DOING {public String getValue(){return "3";} public String getName(){return "进行中";}},
	/** 勘察结束 已办结 */
	DONE {public String getValue(){return "4";} public String getName(){return "已办结";}}, 
	/** 已拒绝 */
	REFUSE {public String getValue(){return "5";} public String getName(){return "已拒绝";}}, 
	/** 已转交 */
	TRANSFER {public String getValue(){return "6";} public String getName(){return "已转交";}}, 
	/** 转交审核中 */
	TRANSFERAUDIT {public String getValue(){return "7";} public String getName(){return "转交审核中";}}, 
	
	OBSOLETE {public String getValue(){return "8";} public String getName(){return "已过活动时间";}},
	/** 其他*/
	OTHER{public String getValue(){return "9";} public String getName(){return "其他";}},
	/** 全部*/
	ALL {public String getValue(){return "100";} public String getName(){return "全部";}};

	
    public abstract String getValue();
    
    public abstract String getName();
    
    public static SurveyTaskStatus convert(String value){
    	if ( "DONE".equals(value) ) {
    		return SurveyTaskStatus.DONE;
    	} else if ("DOING".equals(value)) {
    		return SurveyTaskStatus.DOING;
    	}else if ("DISTRIBUTE".equals(value)) {
    		return SurveyTaskStatus.DISTRIBUTE;
    	} else if ("OVERTIME".equals(value)) {
    		return SurveyTaskStatus.OVERTIME;
    	}else if ("TRANSFER".equals(value)) {
    		return SurveyTaskStatus.TRANSFER;
    	}else if ("TRANSFERAUDIT".equals(value)) {
    		return SurveyTaskStatus.TRANSFERAUDIT;
    	}else if ("OBSOLETE".equals(value)) {
    		return SurveyTaskStatus.OBSOLETE;
    	}
    	return SurveyTaskStatus.OTHER;
    }
}
