package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;


public enum SurveyQuestionSource {
	
	
	SITELIBRARY{public String getValue(){return "1";} public String getName(){return "场地信息库";}}, 

	HOSTINFORMATION {public String getValue(){return "2";} public String getName(){return "承办方资料";}}, 

	SURVEYLIBRARY{public String getValue(){return "3";} public String getName(){return "勘查问题库";}};

    public abstract String getValue();
    
    public abstract String getName();
    
    public static SurveyQuestionSource convert_value(String value){
    	if ( "1".equals(value) ) {
    		return SurveyQuestionSource.SITELIBRARY;
    	} else if ("2".equals(value)) {
    		return SurveyQuestionSource.HOSTINFORMATION;
    	} else if ("3".equals(value)) {
    		return SurveyQuestionSource.SURVEYLIBRARY;
    	} 
    	return null;
    }
    
    public static SurveyQuestionSource convertName(String name){
    	if ( "场地信息库".equals(name) ) {
    		return SurveyQuestionSource.SITELIBRARY;
    	} else if ("承办方资料".equals(name)) {
    		return SurveyQuestionSource.HOSTINFORMATION;
    	} else if ("勘查问题库".equals(name)) {
    		return SurveyQuestionSource.SURVEYLIBRARY;
    	} 
    	return null;
    }
    
    public static List<SurveyQuestionSource> assginList(){
    	List<SurveyQuestionSource> list = new ArrayList<SurveyQuestionSource>();
    	list.add(SurveyQuestionSource.SITELIBRARY);
    	list.add(SurveyQuestionSource.HOSTINFORMATION);
    	list.add(SurveyQuestionSource.SURVEYLIBRARY);
    	return list;
    }
}
