package com.bcxin.risk.train.dto;


import lombok.Data;

import java.util.Map;

/**
 * 视频学习进度
 */
@Data
public class VideoProgressDTO {

    private String videoTitle;

    private String contractorName;

    private String completed;

    private String createOn;

    public VideoProgressDTO(Map<String,Object> map){
        this.videoTitle = safeTransfor(map.get("videoTitle"));
        this.contractorName = safeTransfor(map.get("contractorName"));
        this.completed = safeTransfor(map.get("completed"));
        this.createOn = safeTransfor(map.get("createOn"));
    }


    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author WangChenYi
     * @date 2017年05月08日 下午2:19:22
     * @注意事项 </b>
     * <b>
     */
    private static String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}