package com.bcxin.risk.report.material.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;


/**
 * <b>Function </b> 活动材料上传表单菜单，对应的菜单，模板，当创建新的项目从这里取值，不涉及其他逻辑处理
 * 
 * @author LuoPeng
 * @date 2017年1月4日 下午9:29:32
 * @注意事项 </b>
 * <b>
 */
@Entity
@Table(name = "config_MaterialFormMenuTemplate")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class MaterialFormMenuTemplate extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**  排序*/
	private int seq;

	/** 菜单代码**/
	private String menuCode;

	/**  菜单名称*/
	private String menuName;

	/**  是否为必录项*/
	private String required;

	@OneToOne
	@JoinColumn(name = "class_id")
	private MaterialFormClass formClass;

}
