package com.bcxin.risk.contractor.domain;

import com.bcxin.risk.hibernateplus.entity.Convert;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 温馨提示
 * @author zhangjianhua
 * @date 2018/4/27
 */
@Entity
@Table(name = "sys_servicetips")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Tips extends Convert implements Serializable{

    private static final long serialVersionUID = 1L;

    /**
     * 省份ID，主键
     */
    @Id
    private Long oid;

    /**
     * 创建时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    private Date createOn;

    /**
     * 修改时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    private Date updateOn;
    /**
     * 温馨提示
     */
    private String tips;

}
