package com.bcxin.risk.common.dto.data;

import lombok.Data;

import java.util.Map;

/**
 * <p>
 *  专门修复数据用，不参与业务逻辑
 * </p>
 *
 * @author 罗鹏
 * @date 2018/5/18 
 */
@Data
public class RepairDataDTO {

	private String oid;

	private String tableName;

	private String columnName;

	private String value;

	private String newValue;

	public RepairDataDTO(Map<String,Object> map){
		this.oid = safeTransfor(map.get("oid"));
		this.tableName = safeTransfor(map.get("tableName"));
		this.columnName = safeTransfor(map.get("columnName"));
		this.value = safeTransfor(map.get("value"));
		this.newValue = safeTransfor(map.get("newValue"));
	}

	private static String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}
}
