package com.bcxin.risk.common.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 销售市场，可销售的区域
 * @author luopeng
 *
 */
@Entity
@Table(name = "config_marketregion")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class MarketRegion extends BaseBean {

	private static final long	serialVersionUID	= 1L;

	//省和直辖市
	private String province;

	//市/县
	private String city;

	//父级
	private Long parent_id;

}
