package com.bcxin.risk.activity.dto.data;

import com.bcxin.risk.base.domain.util.CipherDESUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

@Data
public class ActivityDataDTO {

	private String oid;
	
	private String name;
	
	private String userId;

	private String activityNo;

	private String activitySource;

	private String startDate;

	private String endDate ; 

	private String addressCity;
	
	private String address;

	private String province;
	private String city;
	private String area;

	private String number;
	
	private String sponsor;
	
	private String approvalStatus;

	private String primaryStatus;
	
	private String createOn;

	private String activityDate;

	private String activityType;
	
	private String activityStatus;

	private String activityStatusLabel;
	
	private String updateOn;

	private String gov;

	private String isBackUp;

	private String postMaterial ;

	private String isExistsPgbg ;

	private String token;

	private String needReport;

	private Page page;

	private String companyPhone;

	private String securityComId;
	private String securityCompanyName;
	private String dataStatus;

	public ActivityDataDTO(){}

	public ActivityDataDTO(Map<String,Object> map){
		this.oid = safeTransfor(map.get("oid"));
		this.name = safeTransfor(map.get("name"));
		if ( this.name.length() > 20 ) {
			this.name = this.name.substring(0,20)+"..";
		}
		this.activityNo = safeTransfor(map.get("activityNo"));
		this.activitySource = safeTransfor(map.get("activitySource"));
		this.createOn = safeTransfor(map.get("createOn"));
		this.activityDate = safeTransfor(map.get("activityDate"));
		this.updateOn = safeTransfor(map.get("updateOn"));
		this.activityType = safeTransfor(map.get("activityType"));
		this.activityStatus = safeTransfor(map.get("activityStatus"));
		this.primaryStatus = safeTransfor(map.get("primaryStatus"));
		this.userId = safeTransfor(map.get("userId"));
		this.activityStatusLabel = safeTransfor(map.get("activityStatusLabel"));
		this.gov = safeTransfor(map.get("gov"));
		this.isBackUp = safeTransfor(map.get("isBackUp"));
		if(StringUtil.isEmpty(this.isBackUp)){
			this.isBackUp="0";
		}
		this.postMaterial = safeTransfor(map.get("postMaterial"));
		this.isExistsPgbg = safeTransfor(map.get("isExistsPgbg"));

		this.city=safeTransfor(map.get("city"));
		this.area=safeTransfor(map.get("area"));
		this.province=safeTransfor(map.get("province"));
		this.approvalStatus=safeTransfor(map.get("approvalStatus"));
		this.needReport=safeTransfor(map.get("needReport"));

		//d.addressCity,d.address,d.startDate,d.endDate,d.sponsor
		if (StringUtil.isNotEmpty(safeTransfor(map.get("addressCity")))) {
			this.addressCity=safeTransfor(map.get("addressCity"));
		}
		if (StringUtil.isNotEmpty(safeTransfor(map.get("address")))) {
			this.address=safeTransfor(map.get("address"));
		}
		if (StringUtil.isNotEmpty(safeTransfor(map.get("startDate")))) {
			this.startDate=safeTransfor(map.get("startDate"));
		}
		if (StringUtil.isNotEmpty(safeTransfor(map.get("endDate")))) {
			this.endDate=safeTransfor(map.get("endDate"));
		}
		if (StringUtil.isNotEmpty(safeTransfor(map.get("sponsor")))) {
			this.sponsor=safeTransfor(map.get("sponsor"));
		}
		this.token = CipherDESUtil.encrypt(this.oid);
		this.companyPhone = safeTransfor(map.get("companyPhone"));

		if (StringUtil.isNotEmpty(safeTransfor(map.get("securityCompanyName")))) {
			this.securityCompanyName=safeTransfor(map.get("securityCompanyName"));
		}
		if (StringUtil.isNotEmpty(safeTransfor(map.get("securityComId")))) {
			this.securityComId=safeTransfor(map.get("securityComId"));
		}
		if (StringUtil.isNotEmpty(safeTransfor(map.get("dataStatus")))) {
			this.dataStatus=safeTransfor(map.get("dataStatus"));
		}

	}
	
	
	/**
     * 
     * <b>Function 将Object安全转换为String</b> 
     * 
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}

}
