package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 活动监管
 * 记录各项目阶段的时间
 * @author Administrator
 *
 */
@Entity
@Table(name = "RISK_ActivityRecord")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityRecord extends BaseBean {

	private static final long	serialVersionUID	= 1L;

	/**
	 * 活动
	 */
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;

	/**
	 * 关联Id
	 */
	private String relationId;

	/**
	 * 顺序
	 */
	private int seq;

	/**
	 * 子状态，（字典）
	 */
	private String activitySubStep;
	
}
