package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 活动等级评定信息表
 * @author 罗鹏
 */
@Entity
@Table(name = "RISK_Activity_Grade_Rank")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityGradeRank extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 活动
     */
    @ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "activity_id")
    private Activity activity;

    /**
     * 评定类型
     * 10 公安等级评级
     * 11 现场踏勘
     * 12 补充材料
     * 13 承办方申请重评
     * 14 公安不同意调整等级评定
     * 15 公安同意调整等级评定
     */
    private String gradeRankType;

    /**
     * 评定日期
     */
    private Date rankDate;

    /**
     * 评定意见
     */
    private String comments;

    /**
     * 等级评定文件
     */
    private String rankFile;

    /**
     * 评定等级（字典）
     */
	private String gradeRank;

    /**
     * 是否处理
     * 如当 gradeRankType 为12，要求补充材料，需要放开补充材料入口
     * 如当 gradeRankType 为13，要求知道公安有没有反馈
     */
    private String opStatus;


}
