/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum ExpressMode {
    NULL{

        @Override
        public String getValue() {
            return "0";
        }

        @Override
        public String getName() {
            return "\u65e0\u9700\u5bc4\u9001";
        }
    }
    ,
    REPORT{

        @Override
        public String getValue() {
            return "1";
        }

        @Override
        public String getName() {
            return "\u7eb8\u8d28\u62a5\u544a";
        }
    }
    ,
    INVOICE_COMMON{

        @Override
        public String getValue() {
            return "2";
        }

        @Override
        public String getName() {
            return "\u666e\u901a\u53d1\u7968";
        }
    }
    ,
    INVOICE_VAT{

        @Override
        public String getValue() {
            return "3";
        }

        @Override
        public String getName() {
            return "\u589e\u503c\u7a0e\u53d1\u7968";
        }
    }
    ,
    REPORT_INVOICE_COMMON{

        @Override
        public String getValue() {
            return "4";
        }

        @Override
        public String getName() {
            return "\u62a5\u544a+\u666e\u901a\u53d1\u7968";
        }
    }
    ,
    REPORT_INVOICE_VAT{

        @Override
        public String getValue() {
            return "5";
        }

        @Override
        public String getName() {
            return "\u62a5\u544a+\u589e\u503c\u7a0e\u53d1\u7968";
        }
    };


    public abstract String getValue();

    public abstract String getName();

    public static boolean needReport(ExpressMode mode) {
        ArrayList<ExpressMode> list = new ArrayList<ExpressMode>();
        list.add(REPORT);
        list.add(REPORT_INVOICE_COMMON);
        list.add(REPORT_INVOICE_VAT);
        for (ExpressMode expressMode : list) {
            if (!mode.equals((Object)expressMode)) continue;
            return true;
        }
        return false;
    }

    public static boolean needCoomonInvoice(ExpressMode mode) {
        ArrayList<ExpressMode> list = new ArrayList<ExpressMode>();
        list.add(INVOICE_COMMON);
        list.add(REPORT_INVOICE_COMMON);
        for (ExpressMode expressMode : list) {
            if (!mode.equals((Object)expressMode)) continue;
            return true;
        }
        return false;
    }

    public static boolean needVatInvoice(ExpressMode mode) {
        ArrayList<ExpressMode> list = new ArrayList<ExpressMode>();
        list.add(INVOICE_VAT);
        list.add(REPORT_INVOICE_VAT);
        for (ExpressMode expressMode : list) {
            if (!mode.equals((Object)expressMode)) continue;
            return true;
        }
        return false;
    }

    public static boolean needInvoice(ExpressMode mode) {
        ArrayList<ExpressMode> list = new ArrayList<ExpressMode>();
        list.add(INVOICE_COMMON);
        list.add(INVOICE_VAT);
        list.add(REPORT_INVOICE_COMMON);
        list.add(REPORT_INVOICE_VAT);
        for (ExpressMode expressMode : list) {
            if (!mode.equals((Object)expressMode)) continue;
            return true;
        }
        return false;
    }

    public static boolean needBoth(ExpressMode mode) {
        ArrayList<ExpressMode> list = new ArrayList<ExpressMode>();
        list.add(REPORT_INVOICE_COMMON);
        list.add(REPORT_INVOICE_VAT);
        for (ExpressMode expressMode : list) {
            if (!mode.equals((Object)expressMode)) continue;
            return true;
        }
        return false;
    }

    public static List<ExpressMode> list() {
        ArrayList<ExpressMode> list = new ArrayList<ExpressMode>();
        list.add(NULL);
        list.add(REPORT);
        list.add(INVOICE_COMMON);
        list.add(INVOICE_VAT);
        list.add(REPORT_INVOICE_COMMON);
        list.add(REPORT_INVOICE_VAT);
        return list;
    }
}

