package com.bcxin.tenant.domain.snapshots;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;

@Data
public class EmployeeImportedResultSnapshot {
    private  Collection<BatchImportEmployeeResultItem> result;

    public EmployeeImportedResultSnapshot()
    {

    }

    public EmployeeImportedResultSnapshot(Collection<BatchImportEmployeeResultItem> result) {
        this.result = result;
    }

    @JsonIgnore
    public int getTotalSuccess() {
        if (CollectionUtils.isEmpty(result)) {
            return 0;
        }

        return (int) result.stream().filter(ii -> ii.getIsSuccess()).count();
    }

    @JsonIgnore
    public int getTotalFailed() {
        if (CollectionUtils.isEmpty(result)) {
            return 0;
        }

        return (int) result.stream().filter(ii -> !ii.getIsSuccess()).count();
    }

    public static EmployeeImportedResultSnapshot create(Collection<BatchImportEmployeeResultItem> result) {
        return new EmployeeImportedResultSnapshot(result);
    }


    @Data
    public static class BatchImportEmployeeResultItem
    {
        private EmployeeImportedItemSnapshot dataItem;
        private Collection<String> invalidLogs=new ArrayList<>();

        public BatchImportEmployeeResultItem(){}

        public BatchImportEmployeeResultItem(EmployeeImportedItemSnapshot dataItem) {
            this.dataItem = dataItem;
        }

        private void addErrorLogs(Collection<String> errorLogs) {
            this.invalidLogs.addAll(errorLogs);
        }

        @JsonIgnore
        public boolean getIsSuccess() {
            return CollectionUtils.isEmpty(invalidLogs);
        }

        public static BatchImportEmployeeResultItem create(EmployeeImportedItemSnapshot item, Collection<String> invalidLogs) {
            BatchImportEmployeeResultItem result = new BatchImportEmployeeResultItem(item);
            result.addErrorLogs(invalidLogs);

            return result;
        }
    }
}
