package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.Date;

@Getter
public class UpdateUserCredentialCommand extends CommandAbstract {
    private final String id;
    private final CredentialType credentialType;
    private final String name;
    private final String headPhoto;
    private final String number;
    private final Date validDateFrom;
    private final Date validDateTo;
    private final String frontPhoto;
    private final String reversePhoto;
    private final String address;
    private final boolean fromMobile;
    private final String certificateImage;

    @Override
    public void validate() {
        if(!StringUtils.hasLength(this.getId())) {
            throw new ArgumentTenantException("Id无效");
        }

        if (this.getCredentialType() == null) {
            throw new ArgumentTenantException("证件类型不能为空");
        }
    }

    public UpdateUserCredentialCommand(String id,
                                       CredentialType credentialType,
                                       String name, String headPhoto,
                                       String number, Date validDateFrom, Date validDateTo,
                                       String frontPhoto, String reversePhoto,
                                       String address,
                                       boolean fromMobile, String certificateImage) {
        this.id = id;
        this.credentialType = credentialType;
        this.name = name;
        this.headPhoto = headPhoto;
        this.number = number;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.frontPhoto = frontPhoto;
        this.reversePhoto = reversePhoto;
        this.address = address;
        this.fromMobile = fromMobile;
        this.certificateImage = certificateImage;
    }

    public static UpdateUserCredentialCommand create(
            String id,
            CredentialType credentialType,
            String name, String headPhoto,
            String number, Date validDateFrom, Date validDateTo,
            String frontPhoto, String reversePhoto,
            String address,
            boolean fromMobile,String certificateImage) {
        return new UpdateUserCredentialCommand(id, credentialType,
                name, headPhoto, number, validDateFrom, validDateTo, frontPhoto, reversePhoto,
                address,fromMobile, certificateImage);
    }
}
