package com.bcxin.tenant.domain.services.commands.organizationAdmins;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

@Getter
public class DeleteOrganizationAdminCommand extends CommandAbstract {
    private final Collection<String> ids;
    private final String organizationId;

    public DeleteOrganizationAdminCommand(String organizationId, Collection<String> ids) {
        this.ids = ids;
        this.organizationId = organizationId;
    }

    public static DeleteOrganizationAdminCommand create(String organizationId, Collection<String> ids) {
        return new DeleteOrganizationAdminCommand(organizationId, ids);
    }

    @Override
    public void validate() {
        if (CollectionUtils.isEmpty(this.getIds())) {
            throw new ArgumentTenantException("要删除的组织管理员不能为空");
        }

        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new BadTenantException("当前上下文无效, 请联系管理员");
        }

        if (this.getIds().contains(userModel.getEmployeeId())) {
            throw new NotAllowedTenantException("组织管理员不能删除自己");
        }
    }
}