package com.bcxin.tenant.domain.services.commands.externalMembers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import lombok.Getter;

import java.util.Collection;

@Getter
public class UpdateExternalMemberStatusCommand extends CommandAbstract {
    private final Collection<String> ids;
    private final String operatorId;

    private final String operatorName;

    private final ResourceReferenceType referenceType;

    private final String referenceNumber;

    private final ApprovedStatus status;

    private final String note;

    public UpdateExternalMemberStatusCommand(ResourceReferenceType referenceType, String referenceNumber,
                                             Collection<String> ids, String operatorId, String operatorName,
                                             ApprovedStatus status, String note) {
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.ids = ids;
        this.operatorId = operatorId;
        this.operatorName = operatorName;
        this.status = status;
        this.note = note;
    }

    public static UpdateExternalMemberStatusCommand create(ResourceReferenceType referenceType,
                                                           String referenceNumber, Collection<String> ids,
                                                           String operatorId, String operatorName,
                                                           ApprovedStatus status, String note){
        return new UpdateExternalMemberStatusCommand(referenceType,referenceNumber,ids,operatorId,operatorName, status, note);
    }
}
