package com.bcxin.tenant.domain.readers.dtos;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

@Getter
public class EmployeeReportDto extends ResponseAbstract {

    //在职员工总数
    private final Long total;
    //未核验
    private final Long unCheckedCount;
    //已核验
    private final Long checkedCount;
    //已提交
    private final Long commitCount;
    //已签合同
    private Long contractCount;
    //保安员总数
    private final Long secTotal;
    //保安员未核验
    private final Long secUnCheckedCount;
    //保安员已核验
    private final Long secCheckedCount;
    //保安员实名认证中
    private final Long secUnAuthCount;
    //保安员实名认证通过
    private final Long secAuthCount;
    //保安员实名认证失败
    private final Long secAuthFailCount;
    //保安员已签合同
    private Long secContractCount;


    public EmployeeReportDto(Long total,
                             Long unCheckedCount,
                             Long checkedCount,
                             Long commitCount,
                             Long contractCount,
                             Long secTotal,
                             Long secUnCheckedCount,
                             Long secCheckedCount,
                             Long secUnAuthCount,
                             Long secAuthCount,
                             Long secAuthFailCount,
                             Long secContractCount) {
        this.total = total;
        this.unCheckedCount = unCheckedCount;
        this.checkedCount = checkedCount;
        this.commitCount = commitCount;
        this.contractCount = contractCount;
        this.secTotal = secTotal;
        this.secUnCheckedCount = secUnCheckedCount;
        this.secCheckedCount = secCheckedCount;
        this.secUnAuthCount = secUnAuthCount;
        this.secAuthCount = secAuthCount;
        this.secAuthFailCount = secAuthFailCount;
        this.secContractCount = secContractCount;
    }

}
