package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.events.EventAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class SysMessageEvent extends EventAbstract {
    private final Collection<MessageItemEvent> itemEvents;

    public SysMessageEvent(Collection<MessageItemEvent> itemEvents) {
        this.itemEvents = itemEvents;
    }

    public static SysMessageEvent create(Collection<MessageItemEvent> itemEvents) {
        return new SysMessageEvent(itemEvents);
    }

    @Getter
    public static class MessageItemEvent extends EventAbstract{
        private final String organizationId;
        private final String employeeId;
        private final String content;

        public MessageItemEvent(String organizationId, String employeeId, String content) {
            this.organizationId = organizationId;
            this.employeeId = employeeId;
            this.content = content;
        }

        public static MessageItemEvent create(String organizationId, String employeeId, String content)
        {
            return new MessageItemEvent(organizationId,employeeId,content);
        }
    }
}
