package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import lombok.Getter;

@Getter
public class JoinDepartmentEvent extends DomainEventAbstract<String> {
    private final String organizationId;
    private final String employeeId;
    private final String departId;

    public JoinDepartmentEvent(String organizationId, String employeeId, String departId) {
        super(departId);
        this.organizationId = organizationId;

        this.employeeId = employeeId;
        this.departId = departId;
    }

    public static JoinDepartmentEvent create( String organizationId, String employeeId, String departId) {
        return new JoinDepartmentEvent(organizationId, employeeId, departId);
    }
}
