package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.ThirdSystemValue;
import com.bcxin.tenant.domain.entities.valueTypes.UserThirdCheckIdClass;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_user_third_check_status")
@Entity
@IdClass(UserThirdCheckIdClass.class)
public class TenantUserThirdCheckStatusEntity extends EntityAbstract implements IAggregate {
    @Id
    @Column(length = 50, nullable = false)
    private String id;

    /**
     * 第三方系统
     */
    @Id
    @Enumerated(EnumType.ORDINAL)
    @Column(name = "third_system_value",nullable = false)
    private ThirdSystemValue thirdSystemValue;

    /**
     * 提交的请求信息
     */
    @Column(name = "request_json")
    private String requestJson;

    @Column(name = "created_time", nullable = false)
    private Timestamp createdTime;

    public TenantUserThirdCheckStatusEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static TenantUserThirdCheckStatusEntity create(String id,ThirdSystemValue thirdSystemValue,String requestJson){
        TenantUserThirdCheckStatusEntity entity = new TenantUserThirdCheckStatusEntity();
        entity.setId(id);
        entity.setThirdSystemValue(thirdSystemValue);
        entity.setRequestJson(requestJson);

        return entity;
    }
}
