package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_event_subscribed_action_logs")
@Entity
public class EventSubscribedActionLogEntity extends OpEntityAbstract implements IAggregate {
    @Id
    private String id;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "status", nullable = false)
    /**
     * 处理状态
     */
    private ProcessedStatus status;

    @Lob
    private String note;

    @Column(name = "created_time", nullable = false)
    private Timestamp createdTime;

    @ManyToOne
    private EventSubscriberEntity subscriber;

    /**
     * 处理所关联的Id
     */
    @Column(name = "ref_event_id", nullable = false)
    private String refEventId;

    @Column(name = "ref_version",nullable = false)
    private Long refVersion;

    protected EventSubscribedActionLogEntity()
    {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static EventSubscribedActionLogEntity create(EventSubscriberEntity subscriber, String refEventId,
                                                        Long refVersion,
                                                        ProcessedStatus status, String note) {
        EventSubscribedActionLogEntity entity = new EventSubscribedActionLogEntity();
        entity.setId(UUIDUtil.getShortUuid());
        entity.setCreatedTime(Timestamp.from(Instant.now()));
        entity.setSubscriber(subscriber);
        entity.setRefEventId(refEventId);
        entity.setRefVersion(refVersion);
        entity.setStatus(status);
        entity.setNote(note);

        return entity;
    }
}
