package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 字典表
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "config_dict")
@Entity
public class ConfigDictEntity extends EntityAbstract implements IAggregate {

    /**
     * 代码条目ID
     */
    @Id
    private Integer id;
    /**
     * 代码类型
     */
    @Column(name = "code_type",nullable = false, length = 30)
    private String codeType;
    /**
     * 代码中文描述
     */
    @Column(name = "description",length = 255)
    private String description;
    /**
     * 代码值
     */
    @Column(name = "code_value",length = 20)
    private String codeValue;
    /**
     * 代码值中文描述
     */
    @Column(name = "label",length = 100)
    private String label;
    /**
     * 排序
     */
    @Column(name = "seq",length = 2)
    private Integer seq;

}






