package com.bcxin.rest.web.apis.utils;


import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.components.CacheV2Provider;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;

import java.util.Collection;

public class CacheUtil {
    public static void clearDepartments(CacheV2Provider cacheV2Provider,String organizationId,boolean isAllDepartment) {
        cacheV2Provider.delFuzzy(getDepartmentCacheKey(organizationId,isAllDepartment));
    }

    public static void clearDepartments(CacheV2Provider cacheV2Provider,String organizationId,String... employeeIds) {
        for (String employeeId : employeeIds) {
            cacheV2Provider.del(String.format("tenant:department:cache:%s-%s", organizationId, employeeId));
        }
    }

    public static void clearDepartments(CacheV2Provider cacheV2Provider, String organizationId, Collection<String> employeeIds) {
        for (String employeeId : employeeIds) {
            cacheV2Provider.del(String.format("tenant:department:cache:%s-%s", organizationId, employeeId));
        }
    }

    public static String getDepartmentCacheKey(String organizationId,boolean isAllDepartment) {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel != null) {
            if (userModel.isMaster()) {
                isAllDepartment = true;
            }

            if (!isAllDepartment) {
                return String.format("tenant:department:cache:%s-%s", organizationId, userModel.getEmployeeId());
            }
        }

        return String.format("tenant:department:cache:%s*", organizationId);
    }

    public static void clearCurrentOrganizationsCache(CacheV2Provider cacheV2Provider){
        String key = "tenant:department:cache:*";
        cacheV2Provider.delFuzzy(key);
    }

    public static String getCurrentOrganizationsCacheKey() {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel != null) {
            return String.format("tenant:current:organization:cache:%s",  userModel.getId());
        }

        throw new UnAuthorizedTenantException("当前用户不存在!");
    }

    public static String getCurrentProfileCacheKey() {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel != null) {
            return String.format("tenant:current:profile:cache:%s", userModel.getId());
        }

        throw new UnAuthorizedTenantException("当前用户不存在!");
    }

    public static String getTenantUserProfileCacheKey(String tenantUserId) {
        return String.format("tenant:current:profile:cache:%s", tenantUserId);
    }

    public static String getCurrentProfileDetailCacheKey() {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel != null) {
            return String.format("tenant:current:profile:cache:detail:%s", userModel.getId());
        }

        throw new UnAuthorizedTenantException("当前用户不存在!");
    }

    public static String getTenantUserProfileDetailCacheKey(String tenantUserId) {
        return String.format("tenant:current:profile:cache:detail:%s", tenantUserId);
    }

    public static String getEmployeeDetailCacheKey() {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel != null) {
            return String.format("tenant:current:Employee:cache:detail:%s", userModel.getId());
        }

        throw new UnAuthorizedTenantException("当前用户不存在!");
    }

    public static String[] getCurrentProfileDeletedCacheKeys() {
        return new String[]{getCurrentProfileCacheKey()};
    }

    public static String[] getCurrentProfileEmployeeDeletedCachedKeys()
    {
        return new String[]{getCurrentOrganizationsCacheKey(),getEmployeeDetailCacheKey(),getCurrentProfileCacheKey(),getCurrentProfileDetailCacheKey()};
    }

    public static String getCheckStatusForBkt(String id) {
        return String.format("tenant:%s:bkt:status", id);
    }

    public static String[] getTenantUserDeletedCachedKeys(String tenantUserId) {
        return new String[]{getTenantUserProfileCacheKey(tenantUserId), getTenantUserProfileDetailCacheKey(tenantUserId)};
    }
}
